/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.Image;
import org.projectusus.core.basis.Hotspot;
import org.projectusus.ui.colors.UsusUIImages;

public abstract class DisplayHotspot<T extends Hotspot>
implements Comparable<DisplayHotspot<?>> {
    private final T historyHotspot;
    private final T currentHotspot;

    public DisplayHotspot(T historyHotspot, T currentHotspot) {
        this.historyHotspot = historyHotspot;
        this.currentHotspot = currentHotspot;
    }

    public String getName() {
        return this.getCurrentOrOldHotspot().getName();
    }

    public int getMetricsValue() {
        if (this.currentHotspot == null) {
            return 0;
        }
        return this.getCurrentOrOldHotspot().getMetricsValue();
    }

    public T getHotspot() {
        return this.currentHotspot;
    }

    T getOldHotspot() {
        return this.historyHotspot;
    }

    public Image getTrendImage() {
        return UsusUIImages.getSharedImages().getTrendImage(this.oldMetricsValue(), this.currentMetricsValue());
    }

    public T getCurrentOrOldHotspot() {
        return this.currentHotspot == null ? this.historyHotspot : this.currentHotspot;
    }

    public int getTrend() {
        return this.currentMetricsValue() - this.oldMetricsValue();
    }

    public int oldMetricsValue() {
        return this.historyHotspot == null ? 0 : this.historyHotspot.getMetricsValue();
    }

    public int currentMetricsValue() {
        return this.currentHotspot == null ? 0 : this.getMetricsValue();
    }

    public String toString() {
        return String.valueOf(this.getName()) + "-" + this.getMetricsValue() + "[" + super.toString() + "]";
    }

    @Override
    public int compareTo(DisplayHotspot<?> otherHotspot) {
        int otherTrend;
        int otherValue;
        int thisValue = this.getMetricsValue();
        if (thisValue != (otherValue = otherHotspot.getMetricsValue())) {
            return otherValue - thisValue;
        }
        int thisTrend = this.getTrend();
        if (thisTrend != (otherTrend = otherHotspot.getTrend())) {
            return otherTrend - thisTrend;
        }
        return this.getName().compareTo(otherHotspot.getName());
    }

    public String getPath() {
        return this.getCurrentOrOldHotspot().getPath();
    }

    public abstract IFile getFile();
}

