/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.projectusus.core.IUsusModelListener;
import org.projectusus.core.basis.CodeProportion;
import org.projectusus.core.statistics.UsusModelProvider;
import org.projectusus.ui.internal.AnalysisDisplayEntry;
import org.projectusus.ui.internal.DisplayCategories;
import org.projectusus.ui.internal.IDisplayCategory;
import org.projectusus.ui.internal.IDisplayModelListener;
import org.projectusus.ui.internal.MetricStatisticsCategory;
import org.projectusus.ui.internal.Snapshot;

public class AnalysisDisplayModel {
    private static AnalysisDisplayModel instance;
    private final Set<IDisplayModelListener> listeners;
    private Snapshot snapshot = new Snapshot();
    private IUsusModelListener listener;
    private final DisplayCategories displayCategories;

    public static AnalysisDisplayModel displayModel() {
        if (instance == null) {
            instance = new AnalysisDisplayModel();
        }
        return instance;
    }

    private AnalysisDisplayModel() {
        this.listeners = new HashSet<IDisplayModelListener>();
        this.displayCategories = new DisplayCategories();
        this.initModelListener();
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    private void initModelListener() {
        this.listener = new IUsusModelListener(){

            public void ususModelChanged() {
                AnalysisDisplayModel.this.handleUsusModelChanged();
            }
        };
        UsusModelProvider.ususModel().addUsusModelListener(this.listener);
    }

    protected void handleUsusModelChanged() {
        this.displayCategories.replaceCategories(this.createMetricsCategory());
        this.fireUpdateCategories();
    }

    public IDisplayCategory[] getCategories() {
        return this.displayCategories.getCategories();
    }

    private MetricStatisticsCategory createMetricsCategory() {
        List codeProportions = UsusModelProvider.ususModel().getCodeProportions();
        ArrayList<AnalysisDisplayEntry> result = new ArrayList<AnalysisDisplayEntry>();
        for (CodeProportion codeProportion : codeProportions) {
            result.add(this.displayEntryFor(codeProportion));
        }
        return new MetricStatisticsCategory(result.toArray(new AnalysisDisplayEntry[result.size()]));
    }

    private AnalysisDisplayEntry displayEntryFor(CodeProportion codeProportion) {
        this.displayCategories.getAllEntries();
        for (AnalysisDisplayEntry entry : this.displayCategories.getAllEntries()) {
            if (!entry.matches(codeProportion)) continue;
            entry.setCodeProportion(codeProportion);
            return entry;
        }
        return new AnalysisDisplayEntry(codeProportion);
    }

    public List<AnalysisDisplayEntry> getEntriesOfAllCategories() {
        return this.displayCategories.getAllEntries();
    }

    public void createSnapshot() {
        for (AnalysisDisplayEntry entry : this.getEntriesOfAllCategories()) {
            entry.createSnapshot();
        }
        this.snapshot = new Snapshot();
        this.fireSnapshotCreated();
    }

    public void addModelListener(IDisplayModelListener listen) {
        this.listeners.add(listen);
    }

    public void removeModelListener(IDisplayModelListener listen) {
        this.listeners.remove(listen);
    }

    private void fireUpdateCategories() {
        for (IDisplayModelListener listen : this.listeners) {
            listen.updateCategories(this);
        }
    }

    private void fireSnapshotCreated() {
        for (IDisplayModelListener listen : this.listeners) {
            listen.snapshotCreated(this.snapshot);
            listen.updateCategories(this);
        }
    }
}

