/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.projectusus.core.basis.CodeProportion;
import org.projectusus.core.basis.FileHotspot;
import org.projectusus.core.basis.Histogram;
import org.projectusus.core.basis.Hotspot;
import org.projectusus.core.basis.SourceCodeLocation;
import org.projectusus.ui.internal.AnalysisDisplayEntry;

public class AnalysisDisplayEntryTest {
    @Test
    public void noHistory_noHotspots() {
        AnalysisDisplayEntry entry = new AnalysisDisplayEntry(AnalysisDisplayEntryTest.codeProportion(0.5));
        Assert.assertEquals((long)0L, (long)entry.getTrend());
        Assert.assertEquals((long)0L, (long)entry.getAdvancedTrend());
    }

    @Test
    public void smallChangeInHistory_noHotspots() {
        AnalysisDisplayEntry entry = new AnalysisDisplayEntry(AnalysisDisplayEntryTest.codeProportion(0.5));
        entry.setCodeProportion(AnalysisDisplayEntryTest.codeProportion(1.49));
        Assert.assertEquals((long)0L, (long)entry.getTrend());
        Assert.assertEquals((long)0L, (long)entry.getAdvancedTrend());
    }

    @Test
    public void largeChangeInHistory_noHotspots() {
        AnalysisDisplayEntry entry = new AnalysisDisplayEntry(AnalysisDisplayEntryTest.codeProportion(0.5));
        entry.setCodeProportion(AnalysisDisplayEntryTest.codeProportion(1.5));
        Assert.assertEquals((long)1L, (long)entry.getTrend());
        Assert.assertEquals((long)1L, (long)entry.getAdvancedTrend());
    }

    @Test
    public void noHistory_hasEmptyListOfHotspots() {
        AnalysisDisplayEntry entry = new AnalysisDisplayEntry(AnalysisDisplayEntryTest.codeProportion(0.5, new ArrayList<Hotspot>()));
        Assert.assertEquals((long)0L, (long)entry.getTrend());
        Assert.assertEquals((long)0L, (long)entry.getAdvancedTrend());
    }

    @Test
    public void noHistory_hasOneHotspot() {
        ArrayList<Hotspot> hotspots = new ArrayList<Hotspot>();
        hotspots.add((Hotspot)AnalysisDisplayEntryTest.hotspot("A", 5));
        AnalysisDisplayEntry entry = new AnalysisDisplayEntry(AnalysisDisplayEntryTest.codeProportion(0.5, hotspots));
        Assert.assertEquals((long)0L, (long)entry.getTrend());
        Assert.assertEquals((long)0L, (long)entry.getAdvancedTrend());
    }

    @Test
    public void largeChangeInHistory_hasOneHotspot_hotspotRemainsConstant() {
        ArrayList<Hotspot> hotspots = new ArrayList<Hotspot>();
        hotspots.add((Hotspot)AnalysisDisplayEntryTest.hotspot("A", 5));
        AnalysisDisplayEntry entry = new AnalysisDisplayEntry(AnalysisDisplayEntryTest.codeProportion(0.5, hotspots));
        entry.setCodeProportion(AnalysisDisplayEntryTest.codeProportion(2.5, hotspots));
        Assert.assertEquals((long)0L, (long)entry.getTrend());
        Assert.assertEquals((long)0L, (long)entry.getAdvancedTrend());
    }

    @Test
    public void hotspotGotWorse() {
        ArrayList<Hotspot> hotspots = new ArrayList<Hotspot>();
        hotspots.add((Hotspot)AnalysisDisplayEntryTest.hotspot("A", 5));
        AnalysisDisplayEntry entry = new AnalysisDisplayEntry(AnalysisDisplayEntryTest.codeProportion(0.5, hotspots));
        ArrayList<Hotspot> newHotspots = new ArrayList<Hotspot>();
        newHotspots.add((Hotspot)AnalysisDisplayEntryTest.hotspot("A", 10));
        entry.setCodeProportion(AnalysisDisplayEntryTest.codeProportion(0.5, newHotspots));
        Assert.assertEquals((long)0L, (long)entry.getTrend());
        Assert.assertEquals((long)5L, (long)entry.getAdvancedTrend());
    }

    @Test
    public void hotspotGotBetter() {
        ArrayList<Hotspot> hotspots = new ArrayList<Hotspot>();
        hotspots.add((Hotspot)AnalysisDisplayEntryTest.hotspot("A", 5));
        AnalysisDisplayEntry entry = new AnalysisDisplayEntry(AnalysisDisplayEntryTest.codeProportion(0.5, hotspots));
        ArrayList<Hotspot> newHotspots = new ArrayList<Hotspot>();
        newHotspots.add((Hotspot)AnalysisDisplayEntryTest.hotspot("A", 1));
        entry.setCodeProportion(AnalysisDisplayEntryTest.codeProportion(0.5, newHotspots));
        Assert.assertEquals((long)0L, (long)entry.getTrend());
        Assert.assertEquals((long)-4L, (long)entry.getAdvancedTrend());
    }

    @Test
    public void hotspotWasAdded() {
        ArrayList<Hotspot> hotspots = new ArrayList<Hotspot>();
        hotspots.add((Hotspot)AnalysisDisplayEntryTest.hotspot("A", 5));
        AnalysisDisplayEntry entry = new AnalysisDisplayEntry(AnalysisDisplayEntryTest.codeProportion(0.5, hotspots));
        ArrayList<Hotspot> newHotspots = new ArrayList<Hotspot>();
        newHotspots.add((Hotspot)AnalysisDisplayEntryTest.hotspot("A", 5));
        newHotspots.add((Hotspot)AnalysisDisplayEntryTest.hotspot("B", 10));
        entry.setCodeProportion(AnalysisDisplayEntryTest.codeProportion(0.5, newHotspots));
        Assert.assertEquals((long)1L, (long)entry.getTrend());
        Assert.assertEquals((long)10L, (long)entry.getAdvancedTrend());
    }

    @Test
    public void hotspotWasRemoved() {
        ArrayList<Hotspot> hotspots = new ArrayList<Hotspot>();
        hotspots.add((Hotspot)AnalysisDisplayEntryTest.hotspot("A", 5));
        hotspots.add((Hotspot)AnalysisDisplayEntryTest.hotspot("B", 5));
        AnalysisDisplayEntry entry = new AnalysisDisplayEntry(AnalysisDisplayEntryTest.codeProportion(0.5, hotspots));
        ArrayList<Hotspot> newHotspots = new ArrayList<Hotspot>();
        newHotspots.add((Hotspot)AnalysisDisplayEntryTest.hotspot("A", 5));
        entry.setCodeProportion(AnalysisDisplayEntryTest.codeProportion(0.5, newHotspots));
        Assert.assertEquals((long)0L, (long)entry.getTrend());
        Assert.assertEquals((long)-5L, (long)entry.getAdvancedTrend());
    }

    private static CodeProportion codeProportion(double average) {
        return new CodeProportion(null, null, 0, null, average);
    }

    private static CodeProportion codeProportion(double average, ArrayList<Hotspot> hotspots) {
        return new CodeProportion(null, null, null, 0, null, average, hotspots, new Histogram(), null);
    }

    private static FileHotspot hotspot(String name, int metricsValue) {
        return new FileHotspot(new SourceCodeLocation(name, 0, 0), metricsValue, null);
    }
}

