/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.projectusus.core.basis.CodeProportion;
import org.projectusus.core.basis.Histogram;
import org.projectusus.core.basis.LocationType;
import org.projectusus.ui.colors.UsusUIImages;
import org.projectusus.ui.internal.DisplayHotspot;
import org.projectusus.ui.internal.DisplayHotspotCreator;

public class AnalysisDisplayEntry {
    private CodeProportion history;
    private CodeProportion current;
    private List<DisplayHotspot<?>> displayHotspots;

    public AnalysisDisplayEntry(CodeProportion codeProportion) {
        this.history = codeProportion;
        this.setCodeProportion(codeProportion);
    }

    public void setCodeProportion(CodeProportion codeProportion) {
        this.current = codeProportion;
        this.displayHotspots = null;
    }

    public String getLabel() {
        return this.current.getMetricLabel();
    }

    public String getDescription() {
        return this.current.getMetricDescription();
    }

    public double getAverage() {
        return this.current.getAverage();
    }

    public int getViolations() {
        return this.current.getViolations();
    }

    public String getBasis() {
        return this.current.getBasis().toString();
    }

    public boolean isSameKindAs(AnalysisDisplayEntry displayEntry) {
        return this.isSameKindAs(displayEntry.getLabel());
    }

    public boolean isSameKindAs(String otherLabel) {
        return this.getLabel().equals(otherLabel);
    }

    public List<DisplayHotspot<?>> getHotspots() {
        if (this.displayHotspots == null) {
            this.createHotspots();
        }
        return this.displayHotspots;
    }

    private void createHotspots() {
        this.displayHotspots = this.hasHotspots() ? new DisplayHotspotCreator(this.history.getHotspots(), this.current.getHotspots()).hotspots() : new ArrayList();
    }

    public boolean hasHotspots() {
        return this.current.hasHotspots();
    }

    public Image getTrendImage() {
        return UsusUIImages.getSharedImages().getTrendImage(this.getAdvancedTrend());
    }

    public boolean matches(CodeProportion codeProportion) {
        return this.isSameKindAs(codeProportion.getMetricLabel());
    }

    public void createSnapshot() {
        this.history = this.current;
        this.displayHotspots = null;
    }

    int getTrend() {
        if (this.hasHotspots()) {
            return this.getHotspots().size() - this.history.getHotspots().size();
        }
        return (int)(this.getAverage() - this.history.getAverage());
    }

    int getAdvancedTrend() {
        if (!this.hasHotspots()) {
            return this.getTrend();
        }
        int result = 0;
        for (DisplayHotspot<?> hotspot : this.getHotspots()) {
            result += hotspot.getTrend();
        }
        return result;
    }

    public String getToolTipText() {
        return this.current.getToolTipText();
    }

    public Histogram getHistogram() {
        return this.current.getHistogram();
    }

    public LocationType getLocationType() {
        return this.current.getLocationType();
    }
}

