/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.colors;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.projectusus.core.util.Defect;
import org.projectusus.ui.colors.ISharedUsusImages;
import org.projectusus.ui.internal.UsusUIPlugin;

public class UsusUIImages
implements ISharedUsusImages {
    private static URL baseUrl;
    private static final ISharedUsusImages _instance;
    private ImageRegistry imageRegistry;
    private static final String OBJECT = "obj16/";
    private static final String VIEW = "eview16/";

    static {
        _instance = new UsusUIImages();
        String pathPrefix = "icons/full/";
        try {
            Bundle bundle = UsusUIPlugin.getDefault().getBundle();
            baseUrl = new URL(bundle.getEntry("/"), pathPrefix);
        }
        catch (MalformedURLException malfux) {
            throw new Defect((Throwable)malfux);
        }
    }

    private UsusUIImages() {
    }

    public static ISharedUsusImages getSharedImages() {
        return _instance;
    }

    @Override
    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    @Override
    public ImageDescriptor getDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    private void declareImages() {
        this.declare(OBJ_CODE_PROPORTIONS, "obj16/codeproportions.gif");
        this.declare(OBJ_INFO, "obj16/info.gif");
        this.declare(OBJ_WARNINGS, "obj16/warnings.gif");
        this.declare(VIEW_WARNING, "eview16/warning.gif");
        this.declare(OBJ_LEVELUP, "obj16/levelup.gif");
        this.declare(OBJ_LEVELDOWN, "obj16/leveldown.gif");
        this.declare(OBJ_NEW, "obj16/new.gif");
        this.declare(OBJ_DELETED, "obj16/deleted.gif");
    }

    private void declare(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)this.makeIconFileURL(path));
        }
        catch (MalformedURLException malfux) {
            UsusUIPlugin.getDefault().log(malfux);
        }
        this.imageRegistry.put(key, desc);
    }

    private ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.initializeImageRegistry();
        }
        return this.imageRegistry;
    }

    private ImageRegistry initializeImageRegistry() {
        this.imageRegistry = new ImageRegistry(Display.getDefault());
        this.declareImages();
        return this.imageRegistry;
    }

    private URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (baseUrl == null) {
            throw new MalformedURLException();
        }
        return new URL(baseUrl, iconPath);
    }

    @Override
    public Image getTrendImage(int trend) {
        if (trend == 0) {
            return null;
        }
        return this.getImage(trend > 0 ? OBJ_LEVELDOWN : OBJ_LEVELUP);
    }

    @Override
    public Image getTrendImage(int oldMetricsValue, int currentMetricsValue) {
        if (oldMetricsValue == 0) {
            return this.getImage(OBJ_NEW);
        }
        if (currentMetricsValue == 0) {
            return this.getImage(OBJ_DELETED);
        }
        if (oldMetricsValue == currentMetricsValue) {
            return null;
        }
        return this.getImage(currentMetricsValue > oldMetricsValue ? OBJ_LEVELDOWN : OBJ_LEVELUP);
    }
}

