/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.colors;

import org.eclipse.swt.graphics.Color;
import org.junit.Assert;
import org.junit.Test;
import org.projectusus.ui.colors.UsusColors;

public class UsusColorsTest {
    @Test
    public void toHueIsBetween0And360() {
        Assert.assertEquals((long)0L, (long)UsusColors.getSharedColors().toHue(Integer.MIN_VALUE));
        Assert.assertEquals((long)90L, (long)UsusColors.getSharedColors().toHue(-1073741824));
        Assert.assertEquals((long)180L, (long)UsusColors.getSharedColors().toHue(0));
        Assert.assertEquals((long)270L, (long)UsusColors.getSharedColors().toHue(0x3FFFFFFF));
        Assert.assertEquals((long)360L, (long)UsusColors.getSharedColors().toHue(Integer.MAX_VALUE));
    }

    @Test
    public void onlyAdjustTheSaturation() {
        Color darkRed = UsusColors.getSharedColors().getColor("DARK_RED");
        float[] hsbDarkRed = darkRed.getRGB().getHSB();
        Color newColor = UsusColors.getSharedColors().adjustSaturation("DARK_RED", 0.5f);
        float[] hsbNewColor = newColor.getRGB().getHSB();
        Assert.assertEquals((double)this.getSaturation(newColor), (double)0.5, (double)0.0);
        Assert.assertEquals((float)hsbNewColor[0], (float)hsbDarkRed[0], (float)0.0f);
        Assert.assertEquals((float)hsbNewColor[2], (float)hsbDarkRed[2], (float)0.0f);
    }

    @Test
    public void adjustSaturationBetweenMinAndMax() {
        Color starkRed = UsusColors.getSharedColors().adjustSaturation("DARK_RED", 1.0f);
        Assert.assertEquals((double)1.0, (double)this.getSaturation(starkRed), (double)0.01);
        Color fadingRed = UsusColors.getSharedColors().adjustSaturation("DARK_RED", 0.0f);
        Assert.assertEquals((double)0.0, (double)this.getSaturation(fadingRed), (double)0.01);
        Color mediumRed = UsusColors.getSharedColors().adjustSaturation("DARK_RED", 0.6f);
        Assert.assertEquals((double)0.6, (double)this.getSaturation(mediumRed), (double)0.01);
    }

    @Test(expected=IllegalArgumentException.class)
    public void saturationMustNotBeGreaterThanOne() {
        UsusColors.getSharedColors().adjustSaturation("BLACK", 1.1f);
    }

    @Test
    public void saturationIsRoundedToTwoDigitsAfterDecimalPoint() {
        float saturation = UsusColors.getSharedColors().restrictSaturation(0.449f);
        Assert.assertEquals((float)0.45f, (float)saturation, (float)0.0f);
        saturation = UsusColors.getSharedColors().restrictSaturation(0.45f);
        Assert.assertEquals((float)0.45f, (float)saturation, (float)0.0f);
        saturation = UsusColors.getSharedColors().restrictSaturation(0.45454544f);
        Assert.assertEquals((float)0.45f, (float)saturation, (float)0.0f);
    }

    private float getSaturation(Color color) {
        return color.getRGB().getHSB()[1];
    }
}

