/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.colors;

import java.util.Random;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class UsusColors {
    public static final String DARK_RED = "DARK_RED";
    public static final String DARK_GREY = "DARK_GREY";
    public static final String BLACK = "BLACK";
    public static final String WHITE = "WHITE";
    public static final String USUS_LIGHT_BLUE = "USUS_LIGHT_BLUE";
    static final float MIN_SATURATION = 0.0f;
    private static final UsusColors _instance = new UsusColors();
    private ColorRegistry colorRegistry;
    private final Random random = new Random(1L);

    private UsusColors() {
    }

    public static UsusColors getSharedColors() {
        return _instance;
    }

    public Color getColor(String key) {
        return this.getColorRegistry().get(key);
    }

    private void declareColors() {
        this.declare(DARK_RED, new RGB(220, 60, 60));
        this.declare(DARK_GREY, new RGB(100, 100, 100));
        this.declare(BLACK, new RGB(0, 0, 0));
        this.declare(WHITE, new RGB(255, 255, 255));
        this.declare(USUS_LIGHT_BLUE, new RGB(0, 122, 197));
    }

    private void declare(String key, RGB rgb) {
        this.colorRegistry.put(key, rgb);
    }

    private ColorRegistry getColorRegistry() {
        if (this.colorRegistry == null) {
            this.initializeColorRegistry();
        }
        return this.colorRegistry;
    }

    private ColorRegistry initializeColorRegistry() {
        this.colorRegistry = new ColorRegistry(Display.getDefault());
        this.declareColors();
        return this.colorRegistry;
    }

    public Color getNodeColorFor(int someIntValue) {
        String symbolicName = "NODE_COLOR_" + someIntValue;
        ColorRegistry registry = this.getColorRegistry();
        if (!registry.hasValueFor(symbolicName)) {
            int hue = this.toHue(someIntValue);
            float saturation = 0.1f + this.random.nextFloat() / 1.25f;
            float brightness = 0.8f + this.random.nextFloat() / 5.0f;
            registry.put(symbolicName, new RGB((float)hue, saturation, brightness));
        }
        return registry.get(symbolicName);
    }

    int toHue(int value) {
        long positive = ((long)value - Integer.MIN_VALUE) / 2L;
        double y = (double)positive / 2.147483647E9;
        return (int)Math.round(360.0 * y);
    }

    public Color adjustSaturation(String colorKey, float newSaturation) {
        float saturation = this.restrictSaturation(newSaturation);
        String symbolicName = String.valueOf(colorKey) + saturation;
        ColorRegistry registry = this.getColorRegistry();
        if (!registry.hasValueFor(symbolicName)) {
            Color color = this.getColor(colorKey);
            registry.put(symbolicName, this.adjustSaturation(color, saturation));
        }
        return registry.get(symbolicName);
    }

    float restrictSaturation(float newSaturation) {
        float nonNullSaturation = Math.max(0.0f, newSaturation);
        return (float)Math.round(nonNullSaturation * 100.0f) / 100.0f;
    }

    private RGB adjustSaturation(Color color, float saturation) {
        float[] hsb = color.getRGB().getHSB();
        return new RGB(hsb[0], saturation, hsb[2]);
    }
}

