/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.projectsettings.ui.internal;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.projectusus.projectsettings.core.Preferences;
import org.projectusus.projectsettings.ui.internal.SettingsLabelProvider;

public class SelectSettingPage
extends WizardPage {
    private final List<Preferences> projectSettings;
    private Preferences selectedSetting;

    protected SelectSettingPage(List<Preferences> projectSettings) {
        super("");
        this.projectSettings = projectSettings;
        this.setTitle("Select Settings");
        this.setDescription("Select one of the following settings");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText("Available Settings");
        this.createSettingsList(composite);
        this.setControl((Control)composite);
    }

    private void createSettingsList(Composite composite) {
        ListViewer list = new ListViewer(composite, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        list.getList().setLayoutData((Object)gridData);
        list.setContentProvider((IContentProvider)new ArrayContentProvider());
        list.setLabelProvider((IBaseLabelProvider)new SettingsLabelProvider());
        list.setInput(this.projectSettings);
        this.initListener(list);
    }

    private void initListener(ListViewer list) {
        list.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SelectSettingPage.this.setSelectedSetting((Preferences)selection.getFirstElement());
                SelectSettingPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public Preferences getSelectedSetting() {
        return this.selectedSetting;
    }

    public void setSelectedSetting(Preferences selectedSetting) {
        this.selectedSetting = selectedSetting;
    }

    public boolean isProjectSelected() {
        return this.getSelectedSetting() != null;
    }
}

