/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.projectsettings.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.projectusus.projectsettings.core.WhichPrefs;
import org.projectusus.projectsettings.ui.internal.ProjectsLabelProvider;
import org.projectusus.projectsettings.ui.internal.SelectWhichListener;

public class SelectProjectPage
extends WizardPage {
    private final List<IProject> projects;
    private IProject selectedProject;
    private List<WhichPrefs> whichPrefs = new ArrayList<WhichPrefs>();

    public SelectProjectPage(List<IProject> projects) {
        super("SelectProjectPage");
        this.projects = projects;
        this.setTitle("Select Project");
        this.setDescription(this.getDescriptionText());
    }

    protected String getDescriptionText() {
        return "Select a master project. Settings will be copied to the other projects.";
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(this.getDescriptionText());
        this.createCheckbox(composite, "Copy Compiler Warnings Preferences", WhichPrefs.CompilerWarnings);
        this.createCheckbox(composite, "Copy Codecompletion Preferences", WhichPrefs.CodeCompletion);
        this.createCheckbox(composite, "Copy Formatting Preferences", WhichPrefs.Formatting);
        this.createProjectsList(composite);
        this.setControl((Control)composite);
    }

    private void createCheckbox(Composite composite, String label, WhichPrefs whichPref) {
        Button checkbox = new Button(composite, 32);
        checkbox.setText(label);
        GridData gridData = new GridData();
        checkbox.setLayoutData((Object)gridData);
        checkbox.addSelectionListener((SelectionListener)new SelectWhichListener(checkbox, this.getWizard(), this.whichPrefs, whichPref));
    }

    private void createProjectsList(Composite composite) {
        ListViewer list = new ListViewer(composite, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        list.getList().setLayoutData((Object)gridData);
        list.setContentProvider((IContentProvider)new ArrayContentProvider());
        list.setLabelProvider((IBaseLabelProvider)new ProjectsLabelProvider());
        list.setInput(this.projects);
        this.initListener(list);
    }

    private void initListener(ListViewer list) {
        list.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SelectProjectPage.this.setSelectedProject((IProject)selection.getFirstElement());
                SelectProjectPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }

    public void setSelectedProject(IProject selectedProject) {
        this.selectedProject = selectedProject;
    }

    public boolean isProjectSelected() {
        return this.getSelectedProject() != null;
    }

    public WhichPrefs[] getWhichPrefs() {
        return this.whichPrefs.toArray(new WhichPrefs[this.whichPrefs.size()]);
    }
}

