/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.projectsettings.ui.internal;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.handlers.HandlerUtil;
import org.projectusus.projectsettings.core.SettingsAccess;
import org.projectusus.projectsettings.ui.internal.ProjectSelectionExtractor;
import org.projectusus.projectsettings.ui.internal.ProjectSelector;
import org.projectusus.projectsettings.ui.internal.ProjectSelectorResult;

public class CopySettingsFromProject
extends AbstractHandler {
    private final SettingsAccess settingsAccess = new SettingsAccess();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IProject> projects = new ProjectSelectionExtractor(event).getSelectedProjects();
        ProjectSelectorResult projectAndChoice = this.selectProject(event, projects);
        if (projectAndChoice != null) {
            IProject project = projectAndChoice.getProject();
            projects.remove(project);
            this.settingsAccess.transferSettingsFromProject(projects, project, projectAndChoice.getWhichPrefs());
        }
        return null;
    }

    private ProjectSelectorResult selectProject(ExecutionEvent event, List<IProject> projects) throws ExecutionException {
        return new ProjectSelector(HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getShell()).selectProject(projects);
    }
}

