/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.statistics.test;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectusus.core.basis.Hotspot;
import org.projectusus.core.testutil.PrimitiveAssert;
import org.projectusus.core.testutil.PrimitiveMatchers;
import org.projectusus.statistics.LinearMethodLengthStatistic;
import org.projectusus.statistics.test.StatisticTestBase;

public class LinearMethodLengthStatisticTest
extends StatisticTestBase {
    @Before
    public void setup() {
        this.metricsLabel = "MethodLength";
        this.statistic = new LinearMethodLengthStatistic();
    }

    @Test
    public void constants() {
        Assert.assertThat((Object)this.statistic.getLabel(), (Matcher)Matchers.is((Object)"Method length"));
        LinearMethodLengthStatistic cfr_ignored_0 = (LinearMethodLengthStatistic)this.statistic;
        PrimitiveAssert.assertThat((int)9, (Matcher)PrimitiveMatchers.is((int)9));
    }

    @Test
    public void noMethodsYieldAllValues0() {
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)0));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)0));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)0));
        Assert.assertThat((Object)this.statistic.getHotspots(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)PrimitiveMatchers.is((double)0.0));
    }

    @Test
    public void oneMethodWithML1YieldsNoHotspot() {
        this.inspectMethodMetricsValue(1);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)0));
        Assert.assertThat((Object)this.statistic.getHotspots(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)PrimitiveMatchers.is((double)0.0));
    }

    @Test
    public void oneMethodWithML9YieldsNoHotspot() {
        this.inspectMethodMetricsValue(9);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)9));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)0));
        Assert.assertThat((Object)this.statistic.getHotspots(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)PrimitiveMatchers.is((double)0.0));
    }

    @Test
    public void oneMethodWithML10YieldsOneHotspot() {
        this.inspectMethodMetricsValue(10);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)10));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getHotspots().size(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)((Hotspot)this.statistic.getHotspots().get(0)).getMetricsValue(), (Matcher)PrimitiveMatchers.is((int)10));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)11.1111, (double)0.001)));
    }

    @Test
    public void twoMethodsWithML1And10YieldOneHotspot() {
        this.inspectMethodMetricsValue(1);
        this.inspectMethodMetricsValue(10);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)2));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)11));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getHotspots().size(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)((Hotspot)this.statistic.getHotspots().get(0)).getMetricsValue(), (Matcher)PrimitiveMatchers.is((int)10));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)5.5555, (double)0.001)));
    }

    @Test
    public void twoMethodsWithML12And15YieldTwoHotspots() {
        this.inspectMethodMetricsValue(12);
        this.inspectMethodMetricsValue(15);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)2));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)27));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)2));
        PrimitiveAssert.assertThat((int)this.statistic.getHotspots().size(), (Matcher)PrimitiveMatchers.is((int)2));
        PrimitiveAssert.assertThat((int)((Hotspot)this.statistic.getHotspots().get(0)).getMetricsValue(), (Matcher)PrimitiveMatchers.is((int)12));
        PrimitiveAssert.assertThat((int)((Hotspot)this.statistic.getHotspots().get(1)).getMetricsValue(), (Matcher)PrimitiveMatchers.is((int)15));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)PrimitiveMatchers.is((double)50.0));
    }
}

