/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.statistics.test;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectusus.core.basis.Hotspot;
import org.projectusus.core.testutil.PrimitiveAssert;
import org.projectusus.core.testutil.PrimitiveMatchers;
import org.projectusus.statistics.LinearCyclomaticComplexityStatistic;
import org.projectusus.statistics.test.StatisticTestBase;

public class LinearCyclomaticComplexityStatisticTest
extends StatisticTestBase {
    @Before
    public void setup() {
        this.metricsLabel = "CyclomaticComplexity";
        this.statistic = new LinearCyclomaticComplexityStatistic();
    }

    @Test
    public void constants() {
        Assert.assertThat((Object)this.statistic.getLabel(), (Matcher)Matchers.is((Object)"Cyclomatic complexity"));
        LinearCyclomaticComplexityStatistic cfr_ignored_0 = (LinearCyclomaticComplexityStatistic)this.statistic;
        PrimitiveAssert.assertThat((int)4, (Matcher)PrimitiveMatchers.is((int)4));
    }

    @Test
    public void noMethodsYieldAllValues0() {
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)0));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)0));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)0));
        Assert.assertThat((Object)this.statistic.getHotspots(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)PrimitiveMatchers.is((double)0.0));
    }

    @Test
    public void oneMethodWithCC1YieldsNoHotspot() {
        this.inspectMethodMetricsValue(1);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)0));
        Assert.assertThat((Object)this.statistic.getHotspots(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)PrimitiveMatchers.is((double)0.0));
    }

    @Test
    public void oneMethodWithCC4YieldsNoHotspot() {
        this.inspectMethodMetricsValue(4);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)4));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)0));
        Assert.assertThat((Object)this.statistic.getHotspots(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)PrimitiveMatchers.is((double)0.0));
    }

    @Test
    public void oneMethodWithCC5YieldsOneHotspot() {
        this.inspectMethodMetricsValue(5);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)5));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getHotspots().size(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)((Hotspot)this.statistic.getHotspots().get(0)).getMetricsValue(), (Matcher)PrimitiveMatchers.is((int)5));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)PrimitiveMatchers.is((double)25.0));
    }

    @Test
    public void twoMethodsWithCC1And5YieldOneHotspot() {
        this.inspectMethodMetricsValue(1);
        this.inspectMethodMetricsValue(5);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)2));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)6));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getHotspots().size(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)((Hotspot)this.statistic.getHotspots().get(0)).getMetricsValue(), (Matcher)PrimitiveMatchers.is((int)5));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)PrimitiveMatchers.is((double)12.5));
    }

    @Test
    public void twoMethodsWithCC5And7YieldTwoHotspots() {
        this.inspectMethodMetricsValue(5);
        this.inspectMethodMetricsValue(7);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)2));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)12));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)2));
        PrimitiveAssert.assertThat((int)this.statistic.getHotspots().size(), (Matcher)PrimitiveMatchers.is((int)2));
        PrimitiveAssert.assertThat((int)((Hotspot)this.statistic.getHotspots().get(0)).getMetricsValue(), (Matcher)PrimitiveMatchers.is((int)5));
        PrimitiveAssert.assertThat((int)((Hotspot)this.statistic.getHotspots().get(1)).getMetricsValue(), (Matcher)PrimitiveMatchers.is((int)7));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)PrimitiveMatchers.is((double)50.0));
    }
}

