/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.statistics.test;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectusus.core.basis.Hotspot;
import org.projectusus.core.testutil.PrimitiveAssert;
import org.projectusus.core.testutil.PrimitiveMatchers;
import org.projectusus.statistics.LinearClassSizeStatistic;
import org.projectusus.statistics.test.StatisticTestBase;

public class LinearClassSizeStatisticTest
extends StatisticTestBase {
    @Before
    public void setup() {
        this.metricsLabel = "NumberOfMethods";
        this.statistic = new LinearClassSizeStatistic();
    }

    @Test
    public void constants() {
        Assert.assertThat((Object)this.statistic.getLabel(), (Matcher)Matchers.is((Object)"Class size"));
        LinearClassSizeStatistic cfr_ignored_0 = (LinearClassSizeStatistic)this.statistic;
        PrimitiveAssert.assertThat((int)12, (Matcher)PrimitiveMatchers.is((int)12));
    }

    @Test
    public void noClassesYieldAllValues0() {
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)0));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)0));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)0));
        Assert.assertThat((Object)this.statistic.getHotspots(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)PrimitiveMatchers.is((double)0.0));
    }

    @Test
    public void oneClassWithKG1YieldsNoHotspot() {
        this.inspectClassMetricsValue(1);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)0));
        Assert.assertThat((Object)this.statistic.getHotspots(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)PrimitiveMatchers.is((double)0.0));
    }

    @Test
    public void oneClassWithKG12YieldsNoHotspot() {
        this.inspectClassMetricsValue(12);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)12));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)0));
        Assert.assertThat((Object)this.statistic.getHotspots(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)PrimitiveMatchers.is((double)0.0));
    }

    @Test
    public void oneClassWithKG13YieldsOneHotspot() {
        this.inspectClassMetricsValue(13);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)13));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getHotspots().size(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)((Hotspot)this.statistic.getHotspots().get(0)).getMetricsValue(), (Matcher)PrimitiveMatchers.is((int)13));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)8.3333, (double)0.001)));
    }

    @Test
    public void twoClassesWithKG1And13YieldOneHotspot() {
        this.inspectClassMetricsValue(1);
        this.inspectClassMetricsValue(13);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)2));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)14));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)this.statistic.getHotspots().size(), (Matcher)PrimitiveMatchers.is((int)1));
        PrimitiveAssert.assertThat((int)((Hotspot)this.statistic.getHotspots().get(0)).getMetricsValue(), (Matcher)PrimitiveMatchers.is((int)13));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)4.1666, (double)0.001)));
    }

    @Test
    public void twoClassesWithKG13And16YieldTwoHotspots() {
        this.inspectClassMetricsValue(13);
        this.inspectClassMetricsValue(16);
        PrimitiveAssert.assertThat((int)this.statistic.getBasis(), (Matcher)PrimitiveMatchers.is((int)2));
        PrimitiveAssert.assertThat((int)this.statistic.getMetricsSum(), (Matcher)PrimitiveMatchers.is((int)29));
        PrimitiveAssert.assertThat((int)this.statistic.getViolations(), (Matcher)PrimitiveMatchers.is((int)2));
        PrimitiveAssert.assertThat((int)this.statistic.getHotspots().size(), (Matcher)PrimitiveMatchers.is((int)2));
        PrimitiveAssert.assertThat((int)((Hotspot)this.statistic.getHotspots().get(0)).getMetricsValue(), (Matcher)PrimitiveMatchers.is((int)13));
        PrimitiveAssert.assertThat((int)((Hotspot)this.statistic.getHotspots().get(1)).getMetricsValue(), (Matcher)PrimitiveMatchers.is((int)16));
        PrimitiveAssert.assertThat((double)this.statistic.getAverage(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)20.8333, (double)0.001)));
    }
}

