/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.statistics;

import java.util.ArrayList;
import java.util.List;
import org.projectusus.core.basis.CodeProportion;
import org.projectusus.core.basis.Hotspot;
import org.projectusus.core.basis.SourceCodeLocation;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.statistics.CockpitExtension;

public class UnreferencedClassesStatistic
extends CockpitExtension {
    private int violations = 0;
    private List<Hotspot> hotspots = new ArrayList<Hotspot>();

    public UnreferencedClassesStatistic() {
        super("classes", 0);
    }

    public CodeProportion getCodeProportion() {
        for (ClassDescriptor clazz : ClassDescriptor.getAll()) {
            if (!this.shouldBeIncluded(clazz) || !this.hasNoParents(clazz)) continue;
            this.inspectFile(clazz.getFile(), null);
            SourceCodeLocation location = new SourceCodeLocation(clazz.getClassname().toString(), 1, 1);
            this.addResult(location, 1);
        }
        return super.getCodeProportion();
    }

    private boolean hasNoParents(ClassDescriptor clazz) {
        return clazz.getParents().isEmpty();
    }

    private boolean shouldBeIncluded(ClassDescriptor clazz) {
        boolean doesNotEndInContract;
        String name = clazz.getClassname().toString();
        boolean doesNotEndInTest = !name.endsWith("Test");
        boolean bl = doesNotEndInContract = !name.endsWith("Contract");
        return doesNotEndInTest && doesNotEndInContract;
    }

    public int getBasis() {
        return ClassDescriptor.getAll().size();
    }

    public String getLabel() {
        return "Unreferenced classes";
    }

    protected String getRatingFunction() {
        return "\nRating function: f(value) = value";
    }

    protected String getTooltip() {
        return "This statistic examines the number of incoming references to a class.\n" + this.getDescription();
    }

    protected String hotspotsAreUnits() {
        return "that do not have any incoming references.";
    }
}

