/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.statistics;

import java.util.ArrayList;
import java.util.List;
import org.projectusus.core.basis.CodeProportion;
import org.projectusus.core.basis.CodeStatistic;
import org.projectusus.core.basis.Hotspot;
import org.projectusus.core.basis.PackageHotspot;
import org.projectusus.core.filerelations.model.Cycle;
import org.projectusus.core.filerelations.model.PackageCycles;
import org.projectusus.core.filerelations.model.PackageRelations;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.statistics.CockpitExtension;
import org.projectusus.core.statistics.visitors.PackageCountVisitor;

public class PackageCycleStatistic
extends CockpitExtension {
    public PackageCycleStatistic() {
        super("packages", 0);
    }

    public CodeProportion getCodeProportion() {
        CodeStatistic basisStatistic = this.getBasisStatistic();
        PackageCycles packageCycles = new PackageRelations().getPackageCycles();
        int violations = packageCycles.numberOfPackagesInAnyCycles();
        double level = PackageCycleStatistic.calculateAverage((double)violations, (double)basisStatistic.getValue());
        return new CodeProportion(this.getLabel(), this.getDescription(), this.getTooltip(), violations, basisStatistic, level, this.createHotspots(packageCycles), this.getHistogram(), this.getLocationType());
    }

    private List<Hotspot> createHotspots(PackageCycles packageCycles) {
        ArrayList<Hotspot> hotspots = new ArrayList<Hotspot>();
        for (Cycle cycle : packageCycles.getPackageCycles()) {
            int cyclesize = cycle.numberOfElements();
            for (Packagename pack : cycle.getElementsInCycle()) {
                hotspots.add((Hotspot)new PackageHotspot(pack, cyclesize, cycle));
            }
        }
        return hotspots;
    }

    public CodeStatistic getBasisStatistic() {
        return new PackageCountVisitor().visitAndReturn().getCodeStatistic();
    }

    public int getBasis() {
        return this.getBasisStatistic().getValue();
    }

    public int getViolations() {
        return new PackageRelations().getPackageCycles().numberOfPackagesInAnyCycles();
    }

    public String getLabel() {
        return "Packages with cyclic dependencies";
    }

    protected String getRatingFunction() {
        return "\nRating function: f(value) = value";
    }

    protected String getTooltip() {
        return "The underlying metric determines the relationships between classes.\nThe statistic reduces these class relationships to relationships between the packages involved and examines the result with regard to cyclic dependencies.\nSuch dependencies appear when classes are located in the wrong packages. It indicates problems in the design and the structuring of the code.\n" + this.getDescription();
    }

    protected String hotspotsAreUnits() {
        return "that are part of a cycle.";
    }
}

