/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.statistics;

import org.projectusus.core.basis.MetricsResults;
import org.projectusus.core.basis.SourceCodeLocation;
import org.projectusus.core.statistics.CockpitExtension;
import org.projectusus.statistics.LinearClassSizeStatistic;
import org.projectusus.statistics.LinearCyclomaticComplexityStatistic;
import org.projectusus.statistics.LinearMethodLengthStatistic;

public class MudholeStatistic
extends CockpitExtension {
    private static final int MUDHOLE_LIMIT = 49;
    private LinearClassSizeStatistic classSize = new LinearClassSizeStatistic();
    private LinearMethodLengthStatistic methodLength = new LinearMethodLengthStatistic();
    private LinearCyclomaticComplexityStatistic cc = new LinearCyclomaticComplexityStatistic();
    private int currentClassValue;

    public MudholeStatistic() {
        super("methods", 49);
    }

    public void inspectClass(SourceCodeLocation location, MetricsResults results) {
        int result = this.classSize.valueForClass(results);
        this.currentClassValue = result >= 12 ? result : 0;
    }

    public void inspectMethod(SourceCodeLocation location, MetricsResults results) {
        int methodValue = this.methodLength.valueForMethod(results) * this.cc.valueForMethod(results);
        this.addResult(location, methodValue += this.currentClassValue);
    }

    public String getLabel() {
        return "Mudholes";
    }

    protected String hotspotsAreUnits() {
        return this.format("where the product of method length and cyclomatic complexity (increased by the class size if the latter exceeds %d) is greater than %d.", 12, 49);
    }

    protected String getRatingFunction() {
        return this.format("\nRating function: f(ML) * f(CC) + f(KG) > %d", 49);
    }
}

