/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.statistics;

import org.projectusus.core.basis.LocationType;
import org.projectusus.core.basis.MetricsResults;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.statistics.CockpitExtension;

public class LinearPackageLocationSizeStatistic
extends CockpitExtension {
    private static int PKG_LIMIT = 12;
    private double linearViolations = 0.0;

    public LinearPackageLocationSizeStatistic() {
        super("packages/project", PKG_LIMIT);
    }

    public void inspectPackage(Packagename pkg, MetricsResults results) {
        int pkgSize = this.valueForPackage(results);
        this.addResult(pkg, pkgSize, pkg.getClassesInPackage());
        int surplusClasses = pkgSize - PKG_LIMIT;
        if (surplusClasses > 0) {
            this.linearViolations += (double)surplusClasses / (double)PKG_LIMIT;
        }
    }

    public int valueForPackage(MetricsResults results) {
        return results.getIntValue("NumberOfClasses");
    }

    public double getAverage() {
        return LinearPackageLocationSizeStatistic.calculateAverage((double)this.linearViolations, (double)this.getBasis());
    }

    public String getLabel() {
        return "Package size (per project)";
    }

    protected String getTooltip() {
        return "The underlying metric determines the number of classes in each package of a project.\nIf a package occurs in multiple projects, it is counted several times.\nThe class visibility is not taken into account.\n" + this.getDescription();
    }

    protected LocationType getLocationType() {
        return LocationType.PROJECT;
    }

    protected String hotspotsAreUnits() {
        return this.format("with more than %d classes.", PKG_LIMIT);
    }
}

