/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.statistics;

import org.projectusus.core.basis.MetricsResults;
import org.projectusus.core.basis.SourceCodeLocation;
import org.projectusus.core.statistics.CockpitExtension;

public class LinearMethodLengthStatistic
extends CockpitExtension {
    public static final int ML_LIMIT = 9;
    private double linearViolations = 0.0;

    public LinearMethodLengthStatistic() {
        super("methods", 9);
    }

    public void inspectMethod(SourceCodeLocation location, MetricsResults result) {
        int methodLength = this.valueForMethod(result);
        this.addResult(location, methodLength);
        int exceedingLines = methodLength - 9;
        if (exceedingLines > 0) {
            this.linearViolations += (double)exceedingLines / 9.0;
        }
    }

    public int valueForMethod(MetricsResults result) {
        return result.getIntValue("MethodLength");
    }

    public double getAverage() {
        return LinearMethodLengthStatistic.calculateAverage((double)this.linearViolations, (double)this.getBasis());
    }

    protected String hotspotsAreUnits() {
        return this.format("with more than %d statements.", 9);
    }

    public String getLabel() {
        return "Method length";
    }

    protected String getTooltip() {
        return "The underlying metric determines the number of statements in each method body.\nThis value is similar to the number of lines of code, but it ignores empty lines, comments and single brackets.\n" + this.getDescription();
    }
}

