/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.statistics;

import org.projectusus.core.basis.MetricsResults;
import org.projectusus.core.basis.SourceCodeLocation;
import org.projectusus.core.statistics.CockpitExtension;

public class LinearCyclomaticComplexityStatistic
extends CockpitExtension {
    public static final int CC_LIMIT = 4;
    private double linearViolations = 0.0;

    public LinearCyclomaticComplexityStatistic() {
        super("methods", 4);
    }

    public void inspectMethod(SourceCodeLocation location, MetricsResults results) {
        int ccValue = this.valueForMethod(results);
        this.addResult(location, ccValue);
        int exceedingCC = ccValue - 4;
        if (exceedingCC > 0) {
            this.linearViolations += (double)exceedingCC / 4.0;
        }
    }

    public int valueForMethod(MetricsResults results) {
        return results.getIntValue("CyclomaticComplexity", 1);
    }

    public double getAverage() {
        return LinearCyclomaticComplexityStatistic.calculateAverage((double)this.linearViolations, (double)this.getBasis());
    }

    public String getLabel() {
        return "Cyclomatic complexity";
    }

    protected String getTooltip() {
        return "The underlying metric determines the number of possible branches in the execution path through a method body.\nAn empty method body has a cyclomatic complexity of 1. Each occurrence of a branching language element,\ne.g. if, while, catch or the conditional operators && or ||, increases this number by 1.\n" + this.getDescription();
    }

    protected String hotspotsAreUnits() {
        return this.format("with a CC greater than %d.", 4);
    }
}

