/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.statistics;

import org.projectusus.core.basis.MetricsResults;
import org.projectusus.core.basis.SourceCodeLocation;
import org.projectusus.core.statistics.CockpitExtension;

public class LinearClassSizeStatistic
extends CockpitExtension {
    public static final int KG_LIMIT = 12;
    private double linearViolations = 0.0;

    public LinearClassSizeStatistic() {
        super("classes", 12);
    }

    public void inspectClass(SourceCodeLocation location, MetricsResults results) {
        int classSize = this.valueForClass(results);
        this.addResult(location, classSize);
        int surplusMethods = classSize - 12;
        if (surplusMethods > 0) {
            this.linearViolations += (double)surplusMethods / 12.0;
        }
    }

    public int valueForClass(MetricsResults results) {
        return results.getIntValue("NumberOfMethods");
    }

    public double getAverage() {
        return LinearClassSizeStatistic.calculateAverage((double)this.linearViolations, (double)this.getBasis());
    }

    public String getLabel() {
        return "Class size";
    }

    protected String getTooltip() {
        return "The underlying metric determines the number of static and nonstatic methods and initializers in each class.\nThe method visibility is not taken into account.\n" + this.getDescription();
    }

    protected String hotspotsAreUnits() {
        return this.format("with more than %d methods.", 12);
    }
}

