/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.statistics;

import ch.akuhn.foreach.Collect;
import ch.akuhn.foreach.ForEach;
import ch.akuhn.foreach.Select;
import java.util.List;
import java.util.Set;
import org.projectusus.core.basis.CodeProportion;
import org.projectusus.core.basis.CodeStatistic;
import org.projectusus.core.basis.Hotspot;
import org.projectusus.core.basis.SinglePackageHotspot;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.IntraPackageComponents;
import org.projectusus.core.filerelations.model.PackageRelations;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.statistics.CockpitExtension;
import org.projectusus.core.statistics.visitors.PackageCountVisitor;

public class LackOfCohesionOfClassesStatistic
extends CockpitExtension {
    private static final int LCOC_LIMIT = 1;

    public LackOfCohesionOfClassesStatistic() {
        super("packages", 1);
    }

    public CodeProportion getCodeProportion() {
        CodeStatistic basisStatistic = this.getBasisStatistic();
        IntraPackageComponents intraPackageComponents = new IntraPackageComponents();
        int setCount = intraPackageComponents.getComponents().size();
        double level = this.average(setCount, basisStatistic.getValue());
        List<Hotspot> hotspots = this.createHotspots(intraPackageComponents);
        return new CodeProportion(this.getLabel(), this.getDescription(), this.getTooltip(), hotspots.size(), basisStatistic, level, hotspots, this.getHistogram(), this.getLocationType());
    }

    private double average(int setCount, int baseCount) {
        if ((double)baseCount == 0.0) {
            return 0.0;
        }
        return (double)setCount / (double)baseCount;
    }

    private List<Hotspot> createHotspots(IntraPackageComponents intraPackageComponents) {
        List<List<Set<ClassDescriptor>>> listen = this.zusammenhangskomponentenListenFuerMehrteiligePackages(intraPackageComponents);
        for (Collect element : ForEach.collect(listen)) {
            Set menge = (Set)((List)element.value).iterator().next();
            Packagename pkg = ((ClassDescriptor)menge.iterator().next()).getPackagename();
            element.yield = new SinglePackageHotspot(pkg, ((List)element.value).size(), pkg.getOSPath(), pkg.getClassesInPackage());
        }
        return (List)ForEach.result();
    }

    private List<List<Set<ClassDescriptor>>> zusammenhangskomponentenListenFuerMehrteiligePackages(IntraPackageComponents intraPackageComponents) {
        for (Select entry : ForEach.select(intraPackageComponents.getSetsPerPackage().values())) {
            boolean bl = entry.yield = ((List)entry.value).size() > 1;
        }
        return (List)ForEach.result();
    }

    public CodeStatistic getBasisStatistic() {
        return new PackageCountVisitor().visitAndReturn().getCodeStatistic();
    }

    public int getBasis() {
        return this.getBasisStatistic().getValue();
    }

    public int getViolations() {
        return new PackageRelations().getPackageCycles().numberOfPackagesInAnyCycles();
    }

    public String getLabel() {
        return "Lack of cohesion of classes";
    }

    protected String getTooltip() {
        return "This statistic describes the number of unconnected groups of classes in a package.\n" + this.getDescription();
    }

    protected String hotspotsAreUnits() {
        return this.format("with a LCOC greater than %d.", 1);
    }
}

