/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.statistics;

import org.projectusus.core.basis.CodeProportion;
import org.projectusus.core.basis.MetricsResults;
import org.projectusus.core.basis.SourceCodeLocation;
import org.projectusus.core.statistics.CockpitExtension;
import org.projectusus.core.statistics.visitors.ClassCountVisitor;

public class ACDStatistic
extends CockpitExtension {
    private static final int CCD_LIMIT = ACDStatistic.calculateCcdLimit(new ClassCountVisitor().visitAndReturn().getClassCount());

    public ACDStatistic() {
        super("classes", CCD_LIMIT);
    }

    public void inspectClass(SourceCodeLocation location, MetricsResults results) {
        this.addResult(location, results.getIntValue("CCD", 1));
    }

    public double getRelativeACD() {
        int numberOfClasses = new ClassCountVisitor().visitAndReturn().getClassCount();
        if (numberOfClasses == 0) {
            return 0.0;
        }
        return (double)this.getMetricsSum() / (double)(numberOfClasses * numberOfClasses);
    }

    public static int calculateCcdLimit(int classCount) {
        double log_5_classCount = Math.log(classCount) / Math.log(5.0);
        double factor = 1.5 / Math.pow(2.0, log_5_classCount);
        double limit = factor * (double)classCount;
        return (int)limit;
    }

    public CodeProportion getCodeProportion() {
        return new CodeProportion(this.getLabel(), this.getDescription(), this.getTooltip(), this.getViolations(), this.getBasisStatistic(), 100.0 * this.getRelativeACD(), this.getHotspots(), this.getHistogram(), this.getLocationType());
    }

    public String getLabel() {
        return "Average component dependency";
    }

    protected String hotspotsAreUnits() {
        return this.format("with a CCD greater than %d.", CCD_LIMIT);
    }

    protected String getRatingFunction() {
        return "";
    }

    protected String getTooltip() {
        return "The underlying metric is called Cumulative Component Dependency (CCD). It determines for each class the amount of other classes it knows.\nThe corresponding statistic uses the average CCD of all classes in percent, the so-called Average Component Dependency (ACD).\nA class is regarded as hotspot when its CCD exceeds a value that depends on the project size.\nFor small projects, a CCD that equals 15 % of the total number of classes is acceptable, while classes in large projects should not exceed a value of 5 %.\n" + this.getDescription();
    }
}

