/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.mockito.Mockito;
import org.projectusus.core.project2.IUSUSProject;

public class TypeBindingMocker {
    public static ITypeBinding createTypeBinding(String classname, String packagename) throws JavaModelException {
        ITypeBinding binding = (ITypeBinding)Mockito.mock(ITypeBinding.class);
        Mockito.when((Object)binding.getErasure()).thenReturn((Object)binding);
        Mockito.when((Object)binding.getName()).thenReturn((Object)classname);
        IPackageBinding packageBinding = TypeBindingMocker.createPackageBinding(packagename);
        Mockito.when((Object)binding.getPackage()).thenReturn((Object)packageBinding);
        IJavaElement javaElement = TypeBindingMocker.createJavaElement();
        Mockito.when((Object)binding.getJavaElement()).thenReturn((Object)javaElement);
        return binding;
    }

    public static IPackageBinding createPackageBinding(String packagename) {
        IPackageBinding packageBinding = (IPackageBinding)Mockito.mock(IPackageBinding.class);
        Mockito.when((Object)packageBinding.getName()).thenReturn((Object)packagename);
        return packageBinding;
    }

    public static IJavaElement createJavaElement() throws JavaModelException {
        IJavaElement javaElement = (IJavaElement)Mockito.mock(IJavaElement.class);
        IFile file = TypeBindingMocker.createFile();
        Mockito.when((Object)javaElement.getUnderlyingResource()).thenReturn((Object)file);
        return javaElement;
    }

    public static IFile createFile() {
        IFile file = (IFile)Mockito.mock(IFile.class);
        Mockito.when((Object)file.getFileExtension()).thenReturn((Object)"java");
        IProject project = TypeBindingMocker.createProject();
        Mockito.when((Object)file.getProject()).thenReturn((Object)project);
        return file;
    }

    public static IProject createProject() {
        IProject project = (IProject)Mockito.mock(IProject.class);
        Mockito.when((Object)project.isAccessible()).thenReturn((Object)Boolean.TRUE);
        IUSUSProject ususProject = TypeBindingMocker.createUsusProject();
        Mockito.when((Object)project.getAdapter(IUSUSProject.class)).thenReturn((Object)ususProject);
        return project;
    }

    public static IUSUSProject createUsusProject() {
        IUSUSProject ususProject = (IUSUSProject)Mockito.mock(IUSUSProject.class);
        Mockito.when((Object)ususProject.isUsusProject()).thenReturn((Object)Boolean.TRUE);
        return ususProject;
    }
}

