/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics.util;

import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ASTNodeHelper;
import org.projectusus.core.metrics.MetricsCollector;
import org.projectusus.core.statistics.UsusModelProvider;
import org.projectusus.metrics.util.TypeBindingMocker;

public class Setup {
    public static <T extends AbstractTypeDeclaration> T setupCollectorAndMockFor(MetricsCollector collector, Class<T> type, String name) {
        Setup.setupCollector(collector);
        return Setup.setupMockFor(type, name);
    }

    public static void setupCollector(MetricsCollector collector) {
        collector.setup(TypeBindingMocker.createFile(), UsusModelProvider.getMetricsWriter());
    }

    public static <T extends AbstractTypeDeclaration> T setupMockFor(Class<T> type, String name) {
        AbstractTypeDeclaration node = (AbstractTypeDeclaration)Mockito.mock(type);
        Setup.addNameTo(node, name);
        return (T)node;
    }

    public static void addNameTo(AbstractTypeDeclaration theNode, String nodename) {
        SimpleName name = (SimpleName)Mockito.mock(SimpleName.class);
        Mockito.when((Object)name.toString()).thenReturn((Object)nodename);
        Mockito.when((Object)theNode.getName()).thenReturn((Object)name);
    }

    public static <T extends AbstractTypeDeclaration> T setupMockWithStartPosition(Class<T> type, String name, int startPosition, ASTNodeHelper nodeHelper) {
        T node = Setup.setupMockFor(type, name);
        Mockito.when((Object)nodeHelper.getStartPositionFor(node)).thenReturn((Object)startPosition);
        return node;
    }
}

