/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics.test;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectusus.core.filerelations.model.ASTNodeHelper;
import org.projectusus.core.statistics.UsusModelProvider;
import org.projectusus.metrics.PublicFieldCollector;
import org.projectusus.metrics.test.CollectorTestHelper;
import org.projectusus.metrics.util.ClassValueVisitor;
import org.projectusus.metrics.util.Setup;

public class PublicFieldCollectorTest
extends CollectorTestHelper {
    private static final String CLASS_NAME = "ClassName";
    private static final String ANOTHER_CLASS_NAME = "AnotherClassName";
    private PublicFieldCollector collector;
    private TypeDeclaration node;

    @Before
    public void setup() throws JavaModelException {
        this.classVisitor = new ClassValueVisitor("public fields");
        this.nodeHelper = this.setupNodeHelperForClass();
        UsusModelProvider.clear((ASTNodeHelper)this.nodeHelper);
        this.collector = new PublicFieldCollector();
        this.node = Setup.setupCollectorAndMockFor(this.collector, TypeDeclaration.class, CLASS_NAME);
        this.collector.init(this.node);
    }

    @Test
    public void noCalculationsYieldCountOf0() {
        this.collector.commit(this.node);
        this.classVisitor.visit();
        Assert.assertEquals((long)0L, (long)this.classVisitor.getValueMap().get(CLASS_NAME).intValue());
    }

    @Test
    public void publicStaticFinalFieldIsNotCounted() {
        this.collector.calculate(25);
        this.collector.commit(this.node);
        this.classVisitor.visit();
        Assert.assertEquals((long)0L, (long)this.classVisitor.getValueMap().get(CLASS_NAME).intValue());
    }

    @Test
    public void publicNonstaticNonfinalFieldIsCounted() {
        this.collector.calculate(1);
        this.collector.commit(this.node);
        this.classVisitor.visit();
        Assert.assertEquals((long)1L, (long)this.classVisitor.getValueMap().get(CLASS_NAME).intValue());
    }

    @Test
    public void combinationsOfPublicNonstaticNonfinalFieldIsCounted() {
        this.collector.calculate(1);
        this.collector.calculate(9);
        this.collector.calculate(17);
        this.collector.commit(this.node);
        this.classVisitor.visit();
        Assert.assertEquals((long)3L, (long)this.classVisitor.getValueMap().get(CLASS_NAME).intValue());
    }

    @Test
    public void publicFieldsInTwoClassesAreCountedSeparately() {
        this.collector.calculate(1);
        TypeDeclaration node2 = Setup.setupMockWithStartPosition(TypeDeclaration.class, ANOTHER_CLASS_NAME, 100, this.nodeHelper);
        this.collector.init(node2);
        this.collector.calculate(1);
        this.collector.commit(node2);
        this.collector.commit(this.node);
        this.classVisitor.visit();
        Assert.assertEquals((long)1L, (long)this.classVisitor.getValueMap().get(CLASS_NAME).intValue());
        Assert.assertEquals((long)1L, (long)this.classVisitor.getValueMap().get(ANOTHER_CLASS_NAME).intValue());
    }
}

