/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics.test;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectusus.core.filerelations.model.ASTNodeHelper;
import org.projectusus.core.statistics.UsusModelProvider;
import org.projectusus.metrics.MLCollector;
import org.projectusus.metrics.test.CollectorTestHelper;
import org.projectusus.metrics.util.CountingUtils;
import org.projectusus.metrics.util.MethodValueVisitor;
import org.projectusus.metrics.util.TypeBindingMocker;

public class MLCollectorTest
extends CollectorTestHelper {
    private static final String CLASS_NAME = "ClassName";
    private static final String METHOD = "method";
    private static final String CLASS_NAME_METHOD = "ClassName.method()";
    private MLCollector collector;
    private MethodDeclaration method;

    @Before
    public void setup() throws JavaModelException {
        this.methodVisitor = new MethodValueVisitor("MethodLength");
        this.nodeHelper = this.setupNodeHelperForMethod(CLASS_NAME);
        UsusModelProvider.clear((ASTNodeHelper)this.nodeHelper);
        this.method = this.setupMethodDeclMock(METHOD);
        this.collector = new MLCollector();
        this.collector.setup(TypeBindingMocker.createFile(), UsusModelProvider.getMetricsWriter());
        this.collector.init(this.method);
    }

    @Test
    public void methodWithoutStatementsHasML0() {
        this.checkMethodYieldsML(0);
        Assert.assertEquals((long)1L, (long)CountingUtils.getNumberOfClasses());
        Assert.assertEquals((long)1L, (long)CountingUtils.getNumberOfMethods());
    }

    @Test
    public void methodWithOneStatementHasML1() {
        this.collector.calculate(1);
        this.checkMethodYieldsML(1);
    }

    @Test
    public void methodWithTwoSeparateStatementsHasML2() {
        this.collector.calculate(1);
        this.collector.calculate(1);
        this.checkMethodYieldsML(2);
    }

    @Test
    public void methodWithMultipleGroupedStatementsSumsUpItsStatements() {
        this.collector.calculate(3);
        this.collector.calculate(5);
        this.collector.calculate(2);
        this.checkMethodYieldsML(10);
    }

    private void checkMethodYieldsML(int ml) {
        this.collector.commit(this.method);
        this.methodVisitor.visit();
        Assert.assertEquals((long)ml, (long)this.methodVisitor.getValueMap().get(CLASS_NAME_METHOD).intValue());
    }
}

