/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics.test;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.projectusus.metrics.ListStack;

public class ListStackTest {
    private ListStack<String> counter = new ListStack();

    @Test
    public void getAndClearCount_yieldsEmptyList() {
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void startNewCount_yields0() {
        this.counter.startNewList();
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void startNewCount5_yields5() {
        this.counter.startNewList("A");
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.contains((Object[])new String[]{"A"}));
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void startNewCount5_increase1_yields6() {
        this.counter.startNewList("A");
        this.counter.appendLastListWith("B");
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.is((Matcher)Matchers.contains((Object[])new String[]{"A", "B"})));
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void startNewCount3_4_5_yields5_4_3() {
        this.counter.startNewList("A");
        this.counter.startNewList("B");
        this.counter.startNewList("C");
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.contains((Object[])new String[]{"C"}));
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.contains((Object[])new String[]{"B"}));
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.contains((Object[])new String[]{"A"}));
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void startNewCount1_3_5_increase1_yields6_4_2() {
        this.counter.startNewList("A");
        this.counter.appendLastListWith("a");
        this.counter.startNewList("B");
        this.counter.appendLastListWith("b");
        this.counter.startNewList("C");
        this.counter.appendLastListWith("c");
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.contains((Object[])new String[]{"C", "c"}));
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.contains((Object[])new String[]{"B", "b"}));
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.contains((Object[])new String[]{"A", "a"}));
        Assert.assertThat(this.counter.getAndClearList(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }
}

