/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics.test;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ASTNodeHelper;
import org.projectusus.metrics.util.ClassValueVisitor;
import org.projectusus.metrics.util.MethodValueVisitor;
import org.projectusus.metrics.util.TypeBindingMocker;

public class CollectorTestHelper {
    protected ClassValueVisitor classVisitor;
    protected MethodValueVisitor methodVisitor;
    protected ASTNodeHelper nodeHelper;

    protected ASTNodeHelper setupNodeHelperForMethod(String classname) throws JavaModelException {
        ASTNodeHelper helper = this.setupNodeHelperForClass();
        TypeDeclaration parent = this.setupMockFor(TypeDeclaration.class, classname);
        Mockito.when((Object)helper.findEnclosingClassOf((ASTNode)Matchers.any(MethodDeclaration.class))).thenReturn((Object)parent);
        Mockito.when((Object)helper.getStartPositionFor((ASTNode)Matchers.any(ASTNode.class))).thenReturn((Object)1);
        return helper;
    }

    protected ASTNodeHelper setupNodeHelperForClass() throws JavaModelException {
        return this.setupNodeHelperForClass("Classname", "packagename");
    }

    protected ASTNodeHelper setupNodeHelperForClass(String classname, String packagename) throws JavaModelException {
        ASTNodeHelper helper = (ASTNodeHelper)Mockito.mock(ASTNodeHelper.class);
        ITypeBinding typeBinding = TypeBindingMocker.createTypeBinding(classname, packagename);
        Mockito.when((Object)helper.resolveBindingOf((AbstractTypeDeclaration)Matchers.any(AbstractTypeDeclaration.class))).thenReturn((Object)typeBinding);
        return helper;
    }

    protected <T extends AbstractTypeDeclaration> T setupMockFor(Class<T> type, String name) {
        AbstractTypeDeclaration node = (AbstractTypeDeclaration)Mockito.mock(type);
        SimpleName nodename = this.createSimpleNameMockWithName(name);
        Mockito.when((Object)node.getName()).thenReturn((Object)nodename);
        return (T)node;
    }

    protected MethodDeclaration setupMethodDeclMock(String name) {
        MethodDeclaration node = (MethodDeclaration)Mockito.mock(MethodDeclaration.class);
        SimpleName nodename = this.createSimpleNameMockWithName(name);
        Mockito.when((Object)node.getName()).thenReturn((Object)nodename);
        return node;
    }

    private SimpleName createSimpleNameMockWithName(String nodename) {
        SimpleName name = (SimpleName)Mockito.mock(SimpleName.class);
        Mockito.when((Object)name.toString()).thenReturn((Object)nodename);
        return name;
    }
}

