/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics.test;

import org.eclipse.core.resources.IFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Classname;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.filerelations.model.WrappedTypeBinding;
import org.projectusus.core.statistics.UsusModelProvider;
import org.projectusus.metrics.ClassRelationsCollector;
import org.projectusus.metrics.util.Setup;

public class ClassRelationsCollectorTest {
    private static final String NAME_1 = "Name1";
    private static final String NAME_2 = "Name2";
    private static final String XYZ = "xyz";
    private static final IFile file = (IFile)Mockito.mock(IFile.class);
    private final WrappedTypeBinding TYPE_1 = ClassRelationsCollectorTest.createType("Name1");
    private final WrappedTypeBinding TYPE_2 = ClassRelationsCollectorTest.createType("Name2");
    private ClassRelationsCollector collector;

    @Before
    public void setup() {
        UsusModelProvider.clear();
        this.collector = new ClassRelationsCollector();
        Setup.setupCollector(this.collector);
    }

    @Test
    public void selfConnectionIsIgnored() {
        this.collector.connectTypes(this.TYPE_1, this.TYPE_1);
        ClassDescriptor classDescriptor1 = this.findClassDescriptorWithName(NAME_1);
        ClassDescriptor classDescriptor2 = this.findClassDescriptorWithName(NAME_2);
        MatcherAssert.assertThat((Object)classDescriptor1.getChildren(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)classDescriptor2, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void unidirectionalConnectionOfTwoTypesYieldsThatOneIsChildOfTheOther() {
        this.collector.connectTypes(this.TYPE_1, this.TYPE_2);
        ClassDescriptor classDescriptor1 = this.findClassDescriptorWithName(NAME_1);
        ClassDescriptor classDescriptor2 = this.findClassDescriptorWithName(NAME_2);
        MatcherAssert.assertThat((Object)classDescriptor1.getChildren(), (Matcher)Matchers.contains((Object[])new ClassDescriptor[]{classDescriptor2}));
        MatcherAssert.assertThat((Object)classDescriptor2.getChildren(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void bidirectionalConnectionOfTwoTypesYieldsThatTypesAreChildrenOfEachOther() {
        this.collector.connectTypes(this.TYPE_1, this.TYPE_2);
        this.collector.connectTypes(this.TYPE_2, this.TYPE_1);
        ClassDescriptor classDescriptor1 = this.findClassDescriptorWithName(NAME_1);
        ClassDescriptor classDescriptor2 = this.findClassDescriptorWithName(NAME_2);
        MatcherAssert.assertThat((Object)classDescriptor1.getChildren(), (Matcher)Matchers.contains((Object[])new ClassDescriptor[]{classDescriptor2}));
        MatcherAssert.assertThat((Object)classDescriptor2.getChildren(), (Matcher)Matchers.contains((Object[])new ClassDescriptor[]{classDescriptor1}));
    }

    private ClassDescriptor findClassDescriptorWithName(String name) {
        for (ClassDescriptor classDescriptor : ClassDescriptor.getAll()) {
            if (!classDescriptor.getClassname().toString().equals(name)) continue;
            return classDescriptor;
        }
        return null;
    }

    private static WrappedTypeBinding createType(String classname) {
        WrappedTypeBinding aType = (WrappedTypeBinding)Mockito.mock(WrappedTypeBinding.class);
        Mockito.when((Object)aType.getClassname()).thenReturn((Object)new Classname(classname));
        Mockito.when((Object)aType.getPackagename()).thenReturn((Object)Packagename.of((String)XYZ, null));
        Mockito.when((Object)aType.getUnderlyingResource()).thenReturn((Object)file);
        return aType;
    }
}

