/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics.test;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.projectusus.core.filerelations.model.ASTNodeHelper;
import org.projectusus.core.statistics.UsusModelProvider;
import org.projectusus.metrics.CCCollector;
import org.projectusus.metrics.test.CollectorTestHelper;
import org.projectusus.metrics.util.CountingUtils;
import org.projectusus.metrics.util.MethodValueVisitor;
import org.projectusus.metrics.util.TypeBindingMocker;

public class CCCollectorTest
extends CollectorTestHelper {
    private static final String CLASS_NAME = "ClassName";
    private static final String OUTER_CLASS_NAME = "OuterClassName";
    private static final String INNER_METHOD = "innerMethod";
    private static final String METHOD = "method";
    private static final String CLASS_NAME_METHOD = "ClassName.method()";
    private CCCollector collector;
    private MethodDeclaration method;

    @Before
    public void setup() throws JavaModelException {
        this.methodVisitor = new MethodValueVisitor("CyclomaticComplexity");
        this.nodeHelper = this.setupNodeHelperForMethod(CLASS_NAME);
        UsusModelProvider.clear((ASTNodeHelper)this.nodeHelper);
        this.method = this.setupMethodDeclMock(METHOD);
        this.collector = new CCCollector();
        this.collector.setup(TypeBindingMocker.createFile(), UsusModelProvider.getMetricsWriter());
        this.collector.init(this.method);
    }

    @Test
    public void noCalculationYieldsCC1() {
        this.checkMethodYieldsCC(1);
        Assert.assertEquals((long)1L, (long)CountingUtils.getNumberOfClasses());
        Assert.assertEquals((long)1L, (long)CountingUtils.getNumberOfMethods());
    }

    @Test
    public void oneCalculationYieldsCC2() {
        this.collector.calculate(null, 1);
        this.checkMethodYieldsCC(2);
    }

    @Test
    public void twoCalculationsYieldCC3() {
        this.collector.calculate(null, 1);
        this.collector.calculate(null, 1);
        this.checkMethodYieldsCC(3);
    }

    @Test
    public void oneCalculationWith5YieldsCC6() {
        this.collector.calculate(null, 5);
        this.checkMethodYieldsCC(6);
    }

    @Test
    public void calculationsAreSummedUp() {
        this.collector.calculate(null, 5);
        this.collector.calculate(null, 2);
        this.collector.calculate(null, 1);
        this.checkMethodYieldsCC(9);
    }

    @Test
    public void methodInsideMethodYieldsCC2() {
        MethodDeclaration innerMethod = this.setupMethodDeclMock(INNER_METHOD);
        this.collector.init(innerMethod);
        this.collector.commit(innerMethod);
        TypeDeclaration parent = this.setupMockFor(TypeDeclaration.class, OUTER_CLASS_NAME);
        Mockito.when((Object)this.nodeHelper.findEnclosingClassOf((ASTNode)Matchers.any(MethodDeclaration.class))).thenReturn((Object)parent);
        Mockito.when((Object)this.nodeHelper.getStartPositionFor((ASTNode)Matchers.any(ASTNode.class))).thenReturn((Object)100);
        this.collector.commit(this.method);
        this.methodVisitor.visit();
        Assert.assertEquals((long)1L, (long)this.methodVisitor.getValueMap().get("OuterClassName.method()").intValue());
        Assert.assertEquals((long)1L, (long)this.methodVisitor.getValueMap().get("ClassName.innerMethod()").intValue());
    }

    private void checkMethodYieldsCC(int cc) {
        this.collector.commit(this.method);
        this.methodVisitor.visit();
        Assert.assertEquals((long)cc, (long)this.methodVisitor.getValueMap().get(CLASS_NAME_METHOD).intValue());
    }
}

