/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics.test;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectusus.core.filerelations.model.ASTNodeHelper;
import org.projectusus.core.statistics.UsusModelProvider;
import org.projectusus.metrics.AbstractClassCollector;
import org.projectusus.metrics.test.CollectorTestHelper;
import org.projectusus.metrics.util.ClassValueVisitor;
import org.projectusus.metrics.util.CountingUtils;
import org.projectusus.metrics.util.Setup;

public class AbstractClassCollectorTest
extends CollectorTestHelper {
    private static final String ABSTRACT_CLASS_NAME = "AbstractClassName";
    private static final String ENUM_NAME = "EnumName";
    private static final String INTERFACE_NAME = "InterfaceName";
    private static final String ANNOTATION_NAME = "AnnotationName";
    private static final String CLASS_NAME = "ClassName";
    private AbstractClassCollector collector;

    @Before
    public void setup() throws JavaModelException {
        this.classVisitor = new ClassValueVisitor("Abstractness");
        UsusModelProvider.clear((ASTNodeHelper)this.setupNodeHelperForClass());
        this.collector = new AbstractClassCollector();
    }

    @Test
    public void markAsAbstractLeadsToAbstractionCounter1() {
        this.collector.markAsAbstract(Setup.setupCollectorAndMockFor(this.collector, TypeDeclaration.class, CLASS_NAME));
        this.classVisitor.visit();
        Assert.assertEquals((long)1L, (long)this.classVisitor.getValueMap().get(CLASS_NAME).intValue());
        Assert.assertEquals((long)1L, (long)CountingUtils.getNumberOfClasses());
    }

    @Test
    public void markAsConcreteLeadsToAbstractionCounter0() {
        this.collector.markAsConcrete((AbstractTypeDeclaration)Setup.setupCollectorAndMockFor(this.collector, TypeDeclaration.class, CLASS_NAME));
        this.classVisitor.visit();
        Assert.assertEquals((long)0L, (long)this.classVisitor.getValueMap().get(CLASS_NAME).intValue());
        Assert.assertEquals((long)1L, (long)CountingUtils.getNumberOfClasses());
    }

    @Test
    public void abstractnessOfMultipleClassesIsAdditive() {
        this.collector.markAsAbstract(Setup.setupCollectorAndMockFor(this.collector, TypeDeclaration.class, INTERFACE_NAME));
        this.collector.markAsAbstract(Setup.setupCollectorAndMockFor(this.collector, TypeDeclaration.class, ABSTRACT_CLASS_NAME));
        this.collector.markAsConcrete((AbstractTypeDeclaration)Setup.setupCollectorAndMockFor(this.collector, TypeDeclaration.class, CLASS_NAME));
        this.collector.markAsConcrete((AbstractTypeDeclaration)Setup.setupCollectorAndMockFor(this.collector, EnumDeclaration.class, ENUM_NAME));
        this.collector.markAsConcrete((AbstractTypeDeclaration)Setup.setupCollectorAndMockFor(this.collector, AnnotationTypeDeclaration.class, ANNOTATION_NAME));
        this.classVisitor.visit();
        Assert.assertEquals((long)1L, (long)this.classVisitor.getValueMap().get(INTERFACE_NAME).intValue());
        Assert.assertEquals((long)1L, (long)this.classVisitor.getValueMap().get(ABSTRACT_CLASS_NAME).intValue());
        Assert.assertEquals((long)0L, (long)this.classVisitor.getValueMap().get(CLASS_NAME).intValue());
        Assert.assertEquals((long)0L, (long)this.classVisitor.getValueMap().get(ENUM_NAME).intValue());
        Assert.assertEquals((long)0L, (long)this.classVisitor.getValueMap().get(ANNOTATION_NAME).intValue());
        Assert.assertEquals((long)5L, (long)CountingUtils.getNumberOfClasses());
    }
}

