/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics.old;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.projectusus.core.statistics.UsusModelProvider;
import org.projectusus.core.testutil.ReflectionUtil;
import org.projectusus.metrics.Counter;
import org.projectusus.metrics.MLCollector;

public class MLTest {
    private Block block;
    private MLCollector mlChecker;

    @Before
    public void setup() {
        this.block = (Block)Mockito.mock(Block.class);
        this.mlChecker = new MLCollector();
        this.mlChecker.setup((IFile)Mockito.mock(IFile.class), UsusModelProvider.getMetricsWriter());
    }

    @Test
    public void methodSize() throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        int expected = 7;
        this.initBlock(expected);
        this.mlChecker.visit((MethodDeclaration)null);
        this.mlChecker.visit(this.block);
        int actual = ((Counter)ReflectionUtil.getValue((Object)((Object)this.mlChecker), (String)"statementCount")).getAndClearCount();
        Assert.assertEquals((long)expected, (long)actual);
    }

    @Test
    public void initializerSize() throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        int expected = 17;
        this.initBlock(expected);
        this.mlChecker.visit((Initializer)null);
        this.mlChecker.visit(this.block);
        int actual = ((Counter)ReflectionUtil.getValue((Object)((Object)this.mlChecker), (String)"statementCount")).getAndClearCount();
        Assert.assertEquals((long)expected, (long)actual);
    }

    private void initBlock(int count) {
        List statements = (List)Mockito.mock(ArrayList.class);
        Mockito.when((Object)this.block.statements()).thenReturn((Object)statements);
        Mockito.when((Object)new Integer(statements.size())).thenReturn((Object)new Integer(count));
    }
}

