/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics;

import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.projectusus.core.metrics.MetricsCollector;
import org.projectusus.metrics.Counter;

public class PublicFieldCollector
extends MetricsCollector {
    private Counter count = new Counter();

    public boolean visit(TypeDeclaration node) {
        this.init(node);
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this.commit(node);
    }

    public boolean visit(FieldDeclaration node) {
        this.calculate(node.getModifiers());
        return true;
    }

    public void init(TypeDeclaration node) {
        this.count.startNewCount();
    }

    public void calculate(int fieldModifiers) {
        if (this.isPublic(fieldModifiers) && this.isNotStaticFinal(fieldModifiers)) {
            this.count.increaseLastCountBy(1);
        }
    }

    public void commit(TypeDeclaration node) {
        this.getMetricsWriter().putData(this.getFile(), (AbstractTypeDeclaration)node, "public fields", this.count.getAndClearCount());
    }

    private boolean isNotStaticFinal(int modifiers) {
        return (modifiers & 8) == 0 || (modifiers & 0x10) == 0;
    }

    private boolean isPublic(int modifiers) {
        return (modifiers & 1) != 0;
    }
}

