/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics;

import java.util.List;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.projectusus.core.metrics.MetricsCollector;
import org.projectusus.metrics.Counter;

public class MLCollector
extends MetricsCollector {
    private Counter statementCount = new Counter();

    public boolean visit(MethodDeclaration node) {
        this.init(node);
        return true;
    }

    public boolean visit(Initializer node) {
        this.init(node);
        return true;
    }

    public void endVisit(MethodDeclaration node) {
        this.commit(node);
    }

    public void endVisit(Initializer node) {
        this.commit(node);
    }

    public boolean visit(Block node) {
        this.calculate(node.statements().size());
        return true;
    }

    public boolean visit(IfStatement node) {
        this.calculate(this.countNonBlock(node.getThenStatement()) + this.countNonBlock(node.getElseStatement()));
        return true;
    }

    public boolean visit(EnhancedForStatement node) {
        this.calculate(this.countNonBlock(node.getBody()));
        return true;
    }

    public boolean visit(ForStatement node) {
        this.calculate(this.countNonBlock(node.getBody()));
        return true;
    }

    public boolean visit(DoStatement node) {
        this.calculate(this.countNonBlock(node.getBody()));
        return true;
    }

    public boolean visit(WhileStatement node) {
        this.calculate(this.countNonBlock(node.getBody()));
        return true;
    }

    public boolean visit(SwitchStatement node) {
        this.calculate(this.countNonBlocks(node.statements()));
        return true;
    }

    private int countNonBlocks(List<?> statements) {
        int count = 0;
        for (Object stmt : statements) {
            count += this.countNonBlock(stmt);
        }
        return count;
    }

    private int countNonBlock(Object stmt) {
        return stmt instanceof Block ? 0 : 1;
    }

    public void init(MethodDeclaration node) {
        this.statementCount.startNewCount();
    }

    public void init(Initializer node) {
        this.statementCount.startNewCount();
    }

    public void calculate(int count) {
        this.statementCount.increaseLastCountBy(count);
    }

    public void commit(MethodDeclaration node) {
        int count = this.statementCount.getAndClearCount();
        this.getMetricsWriter().putData(this.getFile(), node, "MethodLength", count);
    }

    public void commit(Initializer node) {
        int count = this.statementCount.getAndClearCount();
        this.getMetricsWriter().putData(this.getFile(), node, "MethodLength", count);
    }
}

