/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics;

import java.util.Stack;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.projectusus.core.filerelations.model.ASTNodeHelper;
import org.projectusus.core.filerelations.model.BoundTypeConverter;
import org.projectusus.core.filerelations.model.WrappedTypeBinding;
import org.projectusus.core.metrics.MetricsCollector;

public class ClassRelationsCollector
extends MetricsCollector {
    private Stack<WrappedTypeBinding> types = new Stack();

    public void connectTypes(WrappedTypeBinding sourceType, WrappedTypeBinding targetType) {
        this.getMetricsWriter().addClassReference(sourceType, targetType);
    }

    public void initRawDataTree(AbstractTypeDeclaration node) {
        this.getMetricsWriter().putData(this.getFile(), node, "ClassCreation", 0);
    }

    private void addCurrentType(AbstractTypeDeclaration node) {
        this.initRawDataTree(node);
        this.addCurrentType(new BoundTypeConverter(new ASTNodeHelper()).wrap(node));
    }

    private void addCurrentType(WrappedTypeBinding wrap) {
        this.types.push(wrap);
    }

    private void connectCurrentTypeAnd(WrappedTypeBinding targetType) {
        if (this.currentType() != null && targetType != null && !this.currentType().equals((Object)targetType)) {
            this.connectTypes(this.currentType(), targetType);
        }
    }

    private void dropCurrentType() {
        if (!this.types.empty()) {
            this.types.pop();
        }
    }

    public boolean visit(ImportDeclaration node) {
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        this.addCurrentType((AbstractTypeDeclaration)node);
        return true;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        this.addCurrentType((AbstractTypeDeclaration)node);
        return true;
    }

    public boolean visit(EnumDeclaration node) {
        this.addCurrentType((AbstractTypeDeclaration)node);
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this.dropCurrentType();
    }

    public void endVisit(AnnotationTypeDeclaration node) {
        this.dropCurrentType();
    }

    public void endVisit(EnumDeclaration node) {
        this.dropCurrentType();
    }

    public boolean visit(SimpleType node) {
        this.connectCurrentTypeAnd(new BoundTypeConverter(new ASTNodeHelper()).wrap(node));
        return true;
    }

    public boolean visit(SimpleName node) {
        if (node.isDeclaration()) {
            return false;
        }
        this.connectCurrentTypeAnd(new BoundTypeConverter(new ASTNodeHelper()).wrap(node));
        return true;
    }

    public boolean visit(MethodInvocation node) {
        Expression targetExpression = node.getExpression();
        if (targetExpression == null) {
            this.connectCurrentTypeAnd(new BoundTypeConverter(new ASTNodeHelper()).wrap(node));
        }
        return true;
    }

    public boolean visit(FieldAccess node) {
        Expression targetExpression = node.getExpression();
        if (targetExpression == null) {
            this.connectCurrentTypeAnd(new BoundTypeConverter(new ASTNodeHelper()).wrap(node));
        }
        return true;
    }

    private WrappedTypeBinding currentType() {
        if (this.types.empty()) {
            return null;
        }
        return this.types.peek();
    }
}

