/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.projectusus.core.metrics.MetricsCollector;
import org.projectusus.metrics.Counter;

public class CCCollector
extends MetricsCollector {
    private Counter ccCount = new Counter();

    public boolean visit(MethodDeclaration node) {
        this.init(node);
        return true;
    }

    public boolean visit(Initializer node) {
        this.init(node);
        return true;
    }

    public void endVisit(MethodDeclaration node) {
        this.commit(node);
    }

    public void endVisit(Initializer node) {
        this.commit(node);
    }

    public boolean visit(WhileStatement node) {
        this.calculate((ASTNode)node, 1);
        return true;
    }

    public boolean visit(DoStatement node) {
        this.calculate((ASTNode)node, 1);
        return true;
    }

    public boolean visit(ForStatement node) {
        this.calculate((ASTNode)node, 1);
        return true;
    }

    public boolean visit(EnhancedForStatement node) {
        this.calculate((ASTNode)node, 1);
        return true;
    }

    public boolean visit(IfStatement node) {
        this.calculate((ASTNode)node, 1);
        return true;
    }

    public boolean visit(SwitchCase node) {
        this.calculate((ASTNode)node, 1);
        return true;
    }

    public boolean visit(CatchClause node) {
        this.calculate((ASTNode)node, 1);
        return true;
    }

    public boolean visit(ConditionalExpression node) {
        this.calculate((ASTNode)node, 1);
        return true;
    }

    public boolean visit(InfixExpression node) {
        InfixExpression.Operator operator = node.getOperator();
        if (operator.equals(InfixExpression.Operator.CONDITIONAL_AND) || operator.equals(InfixExpression.Operator.CONDITIONAL_OR)) {
            this.calculate((ASTNode)node, 1 + node.extendedOperands().size());
        }
        return true;
    }

    public void init(MethodDeclaration node) {
        this.ccCount.startNewCount(1);
    }

    public void init(Initializer node) {
        this.ccCount.startNewCount(1);
    }

    public void calculate(ASTNode node, int amount) {
        this.ccCount.increaseLastCountBy(amount);
    }

    public void commit(MethodDeclaration node) {
        this.getMetricsWriter().putData(this.getFile(), node, "CyclomaticComplexity", this.ccCount.getAndClearCount());
    }

    public void commit(Initializer node) {
        this.getMetricsWriter().putData(this.getFile(), node, "CyclomaticComplexity", this.ccCount.getAndClearCount());
    }
}

