/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.metrics;

import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.projectusus.core.metrics.MetricsCollector;

public class AbstractClassCollector
extends MetricsCollector {
    public boolean visit(TypeDeclaration node) {
        if (this.isAbstract(node)) {
            this.markAsAbstract(node);
        } else {
            this.markAsConcrete((AbstractTypeDeclaration)node);
        }
        return true;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        this.markAsConcrete((AbstractTypeDeclaration)node);
        return true;
    }

    public boolean visit(EnumDeclaration node) {
        this.markAsConcrete((AbstractTypeDeclaration)node);
        return true;
    }

    public void markAsAbstract(TypeDeclaration node) {
        this.writeAbstractness((AbstractTypeDeclaration)node, 1);
    }

    public void markAsConcrete(AbstractTypeDeclaration node) {
        this.writeAbstractness(node, 0);
    }

    private boolean isAbstract(TypeDeclaration node) {
        return node.isInterface() || Modifier.isAbstract((int)node.getModifiers());
    }

    private void writeAbstractness(AbstractTypeDeclaration node, int value) {
        this.getMetricsWriter().putData(this.getFile(), node, "Abstractness", value);
    }
}

